/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import catserver.server.utils.LanguageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;

public class ReloadCommand
extends BukkitCommand {
    public ReloadCommand(String name) {
        super(name);
        this.description = "Reloads the server configuration and plugins";
        this.usageMessage = "/reload";
        this.setPermission("bukkit.command.reload");
        this.setAliases(Arrays.asList("rl"));
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + "Please note that this command is not supported and may cause issues when using some plugins.");
        Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + "If you encounter any issues please use the /stop command to restart your server.");
        if (args.length == 0) {
            Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + "------[WARN]------");
            Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + LanguageUtils.I18nToString("command.reload.warn"));
            Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + LanguageUtils.I18nToString("command.reload.warn.confirm"));
        } else if (Objects.equals(args[0], "confirm")) {
            ((CraftServer)Bukkit.getServer()).reloadConfirm();
            Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.GREEN) + "Reload complete.");
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }
}

